/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.outline;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.outline.CommonQuickOutlinePage;
import com.aptana.theme.ThemePlugin;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class QuickOutlinePopupDialog
extends PopupDialog {
    private CommonQuickOutlinePage fPage;
    private AbstractThemeableEditor fEditor;

    public QuickOutlinePopupDialog(Shell parent, AbstractThemeableEditor editor) {
        super(parent, 2064, true, false, false, true, true, null, null);
        this.fPage = new CommonQuickOutlinePage(editor);
        this.fEditor = editor;
    }

    protected Color getBackground() {
        return ThemePlugin.getDefault().getColorManager().getColor(ThemePlugin.getDefault().getThemeManager().getCurrentTheme().getBackground());
    }

    protected Color getForeground() {
        return ThemePlugin.getDefault().getColorManager().getColor(ThemePlugin.getDefault().getThemeManager().getCurrentTheme().getForeground());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.fPage.createControl(composite);
        ISourceViewer viewer = this.fEditor.getISourceViewer();
        int offset = viewer.getTextWidget().getCaretOffset();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 v5 = (ITextViewerExtension5)viewer;
            offset = v5.widgetOffset2ModelOffset(offset);
        }
        if (offset != -1) {
            this.fPage.revealPosition(offset);
        }
        GridDataFactory.fillDefaults().hint(320, 240).applyTo((Control)composite);
        return composite;
    }

    protected Control createTitleControl(Composite parent) {
        return this.fPage.createSearchArea(parent);
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fPage.contributeToQuickOutlineMenu(dialogMenu);
    }

    protected Control getFocusControl() {
        return this.fPage.getSearchBox();
    }
}

